<?php

namespace App\Http\Middleware;

use App\Libraries\Utils;
use Auth;
use Closure;

class AdminAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (Auth::check()) {
            if (Utils::isAdmin(Auth::user()->id)) {
                return $next($request);
            } else {

                if (Utils::isCustomer(Auth::user()->id)) {
                    return redirect()->to('/customer');
                }

                if (Utils::isPublisher(Auth::user()->id)) {
                    return redirect()->to('/publisher');
                }

            }
        } else {
            return redirect()->to('/login');
        }

        return redirect()->to('/login');


    }
}
